#!/bin/sh

#FFmpeg wrapper script for use with Refresh Plugin

PARAMS=""
INPUT=0
for PARAM in "$@"; do
  if [ ${INPUT} = 1 ]; then

    #if the url is of the format 'rtsp://a1709.l1856953708.c18569.g.lm.akamaistream.net:554/D/1709/18569/vnnn/reflector:53708*'
    #extract VVAL from the url for Refresh-on-Demand (Refresh.groovy)
    VVAL="$PARAM"
    VVAL=`expr match "$VVAL" 'rtsp://a1709.l1856953708.c18569.g.lm.akamaistream.net:554/D/1709/18569/v\(.*\)/reflector:53708*'`
    if [[ ! -z "${VVAL}" ]]; then
      curl -X POST "http://localhost:23423/rest/action" -H "Content-Type: text/xml" -d "<action><name>forceOnlineResourceRefresh</name><parameter>${VVAL}</p$
    fi

    #the FFmpeg input filename/URL needs quotes adding back on
    #because it may contain spaces, and the shell has removed them
    PARAMS="${PARAMS} \"${PARAM}\""
    INPUT=0
  else
    PARAMS="${PARAMS} ${PARAM}"
  fi
  if [ "${PARAM}" == "-i" ]; then
    #this loop is the -i parameter, the next loop will be the input filename/URL
    INPUT=1
  fi
done

#invoke FFmpeg
FOLDER="`dirname $0`"
echo "${FOLDER}/ffmpeg ${PARAMS}" > ${FOLDER}/../log/ffmpeg-wrapper.log
echo "${FOLDER}/ffmpeg ${PARAMS}"
eval ${FOLDER}/ffmpeg ${PARAMS}

#return FFmpeg status
echo $?
exit $?
