import groovy.json.JsonSlurper
import org.serviio.library.metadata.*
import org.serviio.library.online.*
import org.serviio.util.*
/**
 * WebResource extractor plugin for hahasport.com.
 * 
 * @author jhb50
 * Version 2 - Apr. 4, 2012
 *
 */
class HaHaSport extends WebResourceUrlExtractor {
	final VALID_FEED_URL = '^(?:https?://)?(?:www\\.)?hahasport\\.com/.+'
	String getExtractorName() {
		return 'HaHaSport'
	}
	Boolean URLExists(URL fileURL){
		if(((HttpURLConnection) fileURL.openConnection()).getResponseCode() == 404){
			return false
		}
		return true
	}
	boolean extractorMatches(URL feedUrl) {
		return feedUrl ==~ VALID_FEED_URL
	}
	WebResourceContainer extractItems(URL resourceUrl, int maxItems) {
		List<WebResourceItem> items = []
		def itemsAdded = 0
		String videoTitle = ""
		String rtmpUrl = ""
		String secCode = ""
		String thumbUrl = ""
		String pageThumb = ""
		String nextTitle = ""
		String itemFlag = "None"
		String linkTitle = ""
		String feed = ""
		String srcUrl = ""
		String videoUrl = ""
		String refreshtxt = ""
		def onDemand = false
		long t30daysi = (30 * 24 * 60) + 5
		long defRefreshi = 0
		def  defRefreshit = ""		
		long nextRefreshi = 0
		long actRefreshi = 0
		long defRefresha = 0
		def  defRefreshat = ""
		long nextRefresha = 0
		def  nextRefreshat = ""
		long actRefresha = 0
		def  actRefreshat = ""
		long lastRefresha = 0
		long lastLiveTime = 0
		def parmMatcher = resourceUrl =~ '^(?:https?://)?(?:www\\.)?hahasport\\.com/.*?refresh=(.[0-9]+).*?'
		def parmMatch = resourceUrl ==~ '^(?:https?://)?(?:www\\.)?hahasport\\.com/.*?refresh=[0-9]+.*?'
		if (parmMatch){
			defRefreshi = parmMatcher[0][1].trim().toLong()  
			defRefreshi = defRefreshi + 5
		}
		else {
			defRefreshi = 65
			onDemand = true
		}
		long curTimea = System.currentTimeMillis()/60000
		nextRefreshi = defRefreshi
		defRefresha = curTimea + defRefreshi  
		nextRefresha = defRefresha
		lastRefresha = defRefresha
		int estreams = 1
		int estreamsCount = 0
		def estreamsMatcher = resourceUrl =~ '^(?:https?://)?(?:www\\.)?hahasport\\.com/.*?streams=([0-9]+)'
		def estreamsMatch = resourceUrl ==~ '^(?:https?://)?(?:www\\.)?hahasport\\.com/.*?streams=[0-9]+'
		if (estreamsMatch){
			estreams = estreamsMatcher[0][1].trim().toInteger()  
		}
		String html = resourceUrl.getText()
		def titleMatcher = html =~ '(?s)<h1 class="title"><span>(.+?)<'
		String pageTitle = titleMatcher[0][1].trim()
		if (onDemand){
			linkTitle = "http://refreshitem"
			srcUrl = "http://refreshitem"
			videoUrl = "http://refreshitem"
			thumbUrl = "https://sites.google.com/site/serviiorss/refresh.jpg"
			videoTitle = "Click to Refresh "
			log ("ADDED 'REFRESH ON DEMAND' ")
			nextRefreshi = t30daysi  
			WebResourceItem item = new WebResourceItem(title: videoTitle, additionalInfo: ['resourceUrl':resourceUrl,'linkTitle':linkTitle,'srcUrl':srcUrl,'videoUrl':videoUrl,'thumbUrl':thumbUrl,'curTimea':curTimea,'defrefreshi':defRefreshi,'nextrefreshi':nextRefreshi])
			items << item
		}
	    if (html.count('<table class') > 0 ){
			def thumbMatcher = html =~ '(?s)<h1 class="title"><span>.+?</span></h1>.*?<tr.*?<td><a href.*?img src="(.*?)".*?'
			pageThumb = "http://www.hahasport.com/" + thumbMatcher[0][1].trim()		
			def videoMatcher = html =~ '(?s)<tr.*?<td><a href.*?time">(.*?)<.*?time">(.*?)<.*?img src=".*?flag.flag-(.*?)".*?<span class=".*?">(.*?)</span>.*?href="(.*?)".*?unescape\\(\'(.*?)\'\\)\\);.*?</script>(.*?)</a>'
			String lastTitle = ""
			for( int i = 0; i < videoMatcher.size() && (maxItems == -1 || itemsAdded < maxItems); i++ ) {
				String videoTitle3 = videoMatcher[i][7].trim()
				while (videoTitle3.contains("( ")) videoTitle3 = videoTitle3.replaceFirst("\\( ","\\(")
				while (videoTitle3.contains(" )")) videoTitle3 = videoTitle3.replaceFirst(" \\)","\\)")
				if (videoTitle3 == "(Unibet TV)" || videoTitle3 == "(Bet365 Video)" || videoTitle3 == "(BWIN)" || videoTitle3 == "(Sopcast)" || videoTitle3 == "(SopCast)" || videoTitle3 == "(Veetle)" || videoTitle3 == "(Cast3d)") continue
				String videoTitle2 = videoMatcher[i][6].trim()
				videoTitle2 = URLDecoder.decode(videoTitle2)
				videoTitle = videoTitle3 + videoTitle2 + "-" + videoMatcher[i][4].trim()
				long sTimea = (videoMatcher[i][1].trim().toLong()/60) 
				long eTimea = (videoMatcher[i][2].trim().toLong()/60) 
				String sTimeat = new Date(sTimea*60000).format('E H:mm').trim()
				String eTimeat = new Date(eTimea*60000).format('H:mm').trim()
				String pTimesat = sTimeat + "-" + eTimeat
				videoTitle = pTimesat + " " + videoTitle	
				if (videoTitle != lastTitle){ 
					estreamsCount = 0
				}
				else if (estreams == estreamsCount && estreams != 9){
					log ("DUPLICATE ITEM - $videoTitle")
					continue
				}
				videoUrl = videoMatcher[i][5].trim()
				if (!URLExists(new URL(videoUrl))){
					log ("404 for $videoUrl")
					continue
				}
				String videohtml = new URL(videoUrl).getText()
				def javaMatch = videohtml ==~ '(?s).*?\'Javascript\'>document.write.*?'
				if (!javaMatch){
					log("NO ENTRIES FOR THIS ITEM - \'$videoTitle\'") 
					continue
				}
				def linkMatcher = videohtml =~ '(?s).*?\'Javascript\'>document.write\\(unescape\\(\'(.*?)\'\\)'
				linkTitle = linkMatcher[0][1].trim()
				linkTitle = URLDecoder.decode(linkTitle)
				if (linkTitle.count("src=") == 0 && linkTitle.count("SRC=") == 0){
					log("NO SRC ITEM - \'$videoTitle\'") 
					continue
				}
				def srcMatcher = linkTitle =~ '(?s).*?[sS][rR][cC]=[\'"](.*?)[\'"&]'
				srcUrl = srcMatcher[0][1].trim()
				if (srcUrl.contains("http://www.ilive.to")) 			feed = "ilivet"
				else if (srcUrl.contains("http://distro.megom.tv"))		feed = "megomt"
				else if (srcUrl.contains("http://leton.tv"))			feed = "letont"
				else if (srcUrl.contains("http://surk.tv"))				feed = "surktv"
				else if (srcUrl.contains("http://www.007stream.com"))	feed = "007str"
				else if (srcUrl.contains("http://www.ustream.tv"))		feed = "ustrea"
				else if (srcUrl.contains("http://www.castalba.tv"))		feed = "castal"
				else if (srcUrl.contains("http://liveview365.tv"))		feed = "liv365"
				else if (srcUrl.contains("http://www.wii-stream.com"))	feed = "wiistr"
				else if (srcUrl.contains("http://www.castup.tv/"))		feed = "castup"
				else if (srcUrl.contains("http://www.castamp.com/"))	feed = "castam"
				else{
					if (srcUrl.contains("sportlemon.tv/images/video.png")) 	feed="offair"
					else feed = srcUrl
					long spread = 3
					long adjsTimea = sTimea + 5 + spread
					if (sTimea > (curTimea + 2400 )) continue
					if (sTimea < curTimea){
						itemFlag = "None"
						log ("NULL ITEM - $feed - $videoTitle")
						continue
					}
					else if (sTimea > (curTimea + spread)){
						if ((sTimea + 5 - spread) < nextRefresha && feed =="offair" ) nextRefresha = sTimea + 5 - spread 
						nextRefreshi = nextRefresha - curTimea
						actRefreshi = nextRefreshi - 5
						actRefreshat = new Date((nextRefresha-5)*60000).format("H:mm 'on' E").trim()						 
						refreshtxt = "Refresh in $actRefreshi mins at $actRefreshat"
						if (onDemand) refreshtxt = "Refresh On Demand"
						nextTitle = videoTitle
						itemFlag = "Next"
						log ("NEXT ITEM - $feed - $videoTitle - $refreshtxt")
						break;
					}
					else if(curTimea < sTimea) {
						if ((sTimea + 5 ) < nextRefresha && feed =="offair" ) nextRefresha = sTimea + 5  
					}
					else{
						if ((sTimea + 5 + spread) < nextRefresha && feed =="offair" ) nextRefresha = sTimea + 5 + spread    
					}							
					itemFlag = itemFlag
					log ("NULL ITEM - $feed - $videoTitle")
					continue					
				}	
				long adjeTimea = eTimea + 15
				if ((adjeTimea > curTimea) && (adjeTimea < nextRefresha)) {
					nextRefresha = adjeTimea 
			        actRefreshat = new Date((nextRefresha-5)*60000).format(" H:mm 'on' E ").trim()	
				}
				else{																					
			        actRefreshat = new Date((nextRefresha-5)*60000).format(" H:mm 'on' E ").trim()		
				}																						 
				nextRefreshi = nextRefresha - curTimea
				String flag = videoMatcher[i][3].trim()
				String myflags = "ae ar at au ba be bg br bw ca cl cn co cz de en es eu fr gh gr hr hu ie it ix kp kw lt ma mx nl no pl pt py qa ro rs ru s2 sa se si sk sz tr ua uk us uy wa za "
				if (myflags.contains(flag)) thumbUrl = "https://sites.google.com/site/hahaflags/" + flag + ".gif"
				else 
				thumbUrl = "http://www.worldatlas.com/webimage/flags/countrys/zzzflags/" + flag + "small.gif"
				refreshtxt = "Refresh at $actRefreshat"
				if (onDemand) refreshtxt = "Refresh On Demand"
				log ("LIVE ITEM - $feed - $videoTitle - $refreshtxt " )
				itemFlag = "Live"
				lastTitle = videoTitle
				lastRefresha = nextRefresha
				lastLiveTime = sTimea
				estreamsCount = estreamsCount + 1
				if (onDemand) nextRefreshi = t30daysi
				WebResourceItem item = new WebResourceItem(title: videoTitle, additionalInfo: ['resourceUrl':resourceUrl,'linkTitle':linkTitle,'srcUrl':srcUrl,'videoUrl':videoUrl,'thumbUrl':thumbUrl,'curTimea':curTimea,'defrefreshi':defRefreshi,'nextrefreshi':nextRefreshi])
				items << item
				itemsAdded++
			}
		}
		if (onDemand){
		nextRefreshi = defRefreshi
		nextRefresha = curTimea + nextRefreshi
		actRefreshat = "at " + new Date((nextRefresha-5)*60000).format("H:mm ").trim()
		}
		else
		if (nextRefreshi == t30daysi) actRefreshat = "at Console Default Time"
		else
			actRefreshat = "at " + new Date((nextRefresha-5)*60000).format("H:mm 'on' E ").trim()
		linkTitle = "http://lastitem"
		srcUrl = "http://lastitem"
		videoUrl = "http://lastitem"
		if (itemFlag == 'Live'){
			thumbUrl = "https://sites.google.com/site/serviiorss/nomoreevents.jpg"
			videoTitle = "Next Refresh $actRefreshat"
			log ("ADDED 'NO MORE EVENTS' - $videoTitle")
		}
		else 
		if (itemFlag == 'Next') {
			thumbUrl = "https://sites.google.com/site/serviiorss/nextevent.jpg"
			videoTitle = "$nextTitle - Next Refresh $actRefreshat "
			log ("ADDED 'NEXT EVENT' - $videoTitle")
		}
		else
		if (itemFlag == 'None') {
			thumbUrl = "https://sites.google.com/site/serviiorss/noevents.jpg"
			videoTitle = "Next Refresh $actRefreshat"
			log ("ADDED 'NO EVENTS' - $videoTitle")
		}
		WebResourceItem item = new WebResourceItem(title: videoTitle, additionalInfo: ['resourceUrl':resourceUrl,'linkTitle':linkTitle,'srcUrl':srcUrl,'videoUrl':videoUrl,'thumbUrl':thumbUrl,'curTimea':curTimea,'defrefreshi':defRefreshi,'nextrefreshi':nextRefreshi])
		items << item
		return new WebResourceContainer(title: pageTitle, thumbnailUrl: pageThumb, items: items)
	}
	ContentURLContainer extractUrl(WebResourceItem item, PreferredQuality requestedQuality) {		
		String videoTitle = item.title
		String resourceUrl = item.getAdditionalInfo()['resourceUrl']
		String linkTitle = item.getAdditionalInfo()['linkTitle']
		String srcUrl = item.getAdditionalInfo()['srcUrl']
		String videoUrl = item.getAdditionalInfo()['videoUrl']
		String thumbnailUrl = item.getAdditionalInfo()['thumbUrl']
		String feed = ""
		String secCode = ""
		String rtmpUrl = ""
		if (srcUrl.contains("http://www.ilive.to")){
			srcUrl = srcUrl.replaceAll("embed","view")
			log("Source Link: $srcUrl")
			String linkHtml = new URL(srcUrl).getText()
			def secMatcher = linkHtml =~ '(?s).*?redirect&file=(.*?).flv'
			if(!secMatcher){
				log ("ILIVE - No secCode - $videoTitle")
				return null
			}
			secCode = secMatcher[0][1].trim()
			rtmpUrl = "rtmp://176.31.231.57/edge swfUrl=http://static.ilive.to/jwplayer/player.swf pageURL=http://www.ilive.to/ playpath=" + secCode
		}
		else if (srcUrl.contains("http://distro.megom.tv")){
			log("Source Link: $srcUrl")
			String linkHtml = new URL(srcUrl).getText()
			def errorMatch = linkHtml ==~ '(?s).*?ban.png.*?'
			if (errorMatch){
				log ("MEGOM - Video Banned - $videoTitle")
				return null
			}
			def rtmpMatcher = linkHtml =~ /(?s).*?testkey=(.*?)['<].*?/
			if(!rtmpMatcher){
				log ("MEGOM - No testkey - $videoTitle")
				return null
			}
			String rtmpKey = rtmpMatcher[0][1].trim()
			def secMatcher = linkHtml =~ /(?s).*?'file','(.*?)'.*?/
			secCode = secMatcher[0][1].trim()
			rtmpUrl = "rtmp://213.163.71.196:1935/streams?testkey=" + rtmpKey + " swfUrl=http://lds.megom.tv/player.swf pageURL=http://distro.megom.tv/player-inside.php?id=" + secCode + " playpath=" + secCode 
		}
		else if (srcUrl.contains("http://leton.tv")){
			log("Source Link: $srcUrl")
			String linkHtml = new URL(srcUrl).getText()
			def errorMatch = linkHtml ==~ '(?s).*?letonban.png.*?'
			if (errorMatch){
				log ("LETON - Video Banned - $videoTitle")	
				return null
			}
			def rtmpMatcher = linkHtml =~ /(?s).*?testkey=(.*?)'.*?/
			if(!rtmpMatcher){
				log ("LETON - No testkey - $videoTitle")
				return null
			}
			def secMatcher = linkHtml =~ /(?s).*?'file','(.*?)'.*?/
			secCode = secMatcher[0][1].trim()
			String rtmpKey = rtmpMatcher[0][1].trim()
			rtmpUrl = "rtmp://213.163.71.196/pull?testkey=" + rtmpKey + " swfUrl=http://files.leton.tv/player.swf pageUrl=files.leton.tv playpath=" + secCode 
		}
		else if (srcUrl.contains("http://surk.tv")){
			def secMatcher = linkTitle =~ '(?s).*?id=(.*?)&.*?'
			if (!secMatcher) secMatcher = linkTitle =~ /(?s).*?id=['"](.*?)['"].*?/
			if(!secMatcher){
				log ("SURK - No secCode - $videoTitle")
				return null
			}
			secCode = secMatcher[0][1].trim()
			secCode = secCode.replaceAll('"','')
			srcUrl = "http://surk.tv/embebed.php?id=" + secCode
			log("Source Link: $srcUrl")
			rtmpUrl = "rtmp://178.33.229.122:1935/liverepeater/_definst_/" + secCode + " pageUrl=http://surk.tv/ playpath=" + secCode 
		}
		else if (srcUrl.contains("http://www.007stream.com")){
			log("Source Link: $srcUrl")
			def fileMatcher = linkTitle =~ '(?s).*?file=(.*?)&'
			String fileNum = fileMatcher[0][1].trim()
			String linkHtml = new URL(srcUrl).getText()
			def urlMatcher = linkHtml =~ '(?s).*?iframe.src="(.*?)"'
			String urlCode = urlMatcher[0][1].trim()
			String urlHtml = new URL(urlCode).getText()
			def errorMatch
			errorMatch = urlHtml ==~ '(?s).*?>Referer Blocked By Admin.*?'
			if (errorMatch){
				log ("007STREAM - Referer Blocked By Admin - $videoTitle")
				return null
			}
			errorMatch = urlHtml ==~ '(?s).*?<p.*?>Protect stream.*?'
			if (errorMatch){
				log ("007STREAM - Protected stream - $videoTitle")
				return null
			}
			def codeMatcher = urlHtml =~ /(?s).*?var.sUrl.=.'(.*?)'.*?var.cod1.=.'(.*?)=.*?var.cod2.=.'(.*?)=/
			if(!codeMatcher){
				log ("007 - No rtmp info - $videoTitle")
				return null
			}
			String urlbit  = codeMatcher[0][1].trim()
			String cod1bit = codeMatcher[0][2].trim()
			cod1bit = URLEncoder.encode(cod1bit)
			String cod2bit = codeMatcher[0][3].trim()
			cod2bit = URLEncoder.encode(cod2bit)
			String secUrl = urlbit + "?callback=jQuery17&v_cod1=" + cod1bit + "%3D&v_cod2=" + cod2bit + "%3D&_=10"
			String secHtml = new URL(secUrl).getText()
			def secMatcher = secHtml =~ '(?s).*?result1":"(.*?)"'
			if(!secMatcher){
				log ("007 - No secCode - $videoTitle")
				return null
			}
			secCode  = secMatcher[0][1].trim()
			rtmpUrl = "rtmp://stream.dinozap.tv:1935/vod/_definst_/" + secCode + " swfUrl=http://www.007stream.com/player.swf pageUrl=http://www.007stream.com/channel.php?file=" + fileNum + " playpath=" + secCode
		}
		else if (srcUrl.contains("http://www.ustream.tv")){
			log("Source Link: $srcUrl")
			def fileMatcher = linkTitle =~ '(?s).*?popup/(.*?)"'
			def fileNum = fileMatcher[0][1].trim()
			def linkUrl = "http://cgw.ustream.tv/Viewer/getStream/1/" +fileNum + ".amf"
			String linkHtml = new URL(linkUrl).getText()
			def errorMatch = linkHtml ==~ '(?s).*?status...online.*?'
			if (!errorMatch){
				log ("USTREAM - stream is offline - $videoTitle")
				return null
			}
			def cdnMatch = linkHtml ==~ '(?s).*?cdnUrl.*?'
			def linkMatcher
			String rtmplink
			if (cdnMatch){
				linkMatcher = linkHtml =~ '(?s).*?cdnUrl...(.*?)[\\x00-\\x20].*?'
				if(!linkMatcher){
					log ("007 - No cdnUrl - $videoTitle")
					return null
				}
				rtmplink = linkMatcher[0][1].trim()
			}
			else {
				linkMatcher = linkHtml =~ '(?s).*?fmsUrl...(.*?)[\\x00-\\x20].*?'
				if(!linkMatcher){
					log ("007 - No fmsUrl - $videoTitle")
					return null
				}
				rtmplink = linkMatcher[0][1].trim()
				rtmplink = rtmplink.replaceFirst("tv/ustreamV","tv:1935/ustreamV")
				rtmplink = rtmplink + "/"
			}
			def linkMatcher2 = linkHtml =~ '(?s).*?streamName...(.*?)[\\x00-\\x20].*?'
			if(!linkMatcher2){
				log ("Ustream - No secCode - $videoTitle")
				return null
			}
			secCode = linkMatcher2[0][1].trim()
			rtmpUrl = rtmplink + " swfUrl=http://static-cdn1.ustream.tv/swf/live/viewer.rsl:96.swf pageUrl=http://www.ustream.tv playpath=" + secCode + " swfVfy=1 live=1"
		}
		else if (srcUrl.contains("http://www.castalba.tv")){
			def idMatcher = linkTitle =~ '(?s).*?id="(.*?)"'
			def id = idMatcher[0][1].trim()
			srcUrl = "http://castalba.tv/embed.php?cid=" + id
			log("Source Link: $srcUrl")
			String linkHtml = new URL(srcUrl).getText()
			def errorMatch = linkHtml ==~ '(?s).*?Banned due to Copyright Infringement.*?'
			if (errorMatch){
				log ("CASTALBA - Banned due to Copyright Infringement - $videoTitle")
				return null
			}
			def linkMatcher = linkHtml =~ /(?s).*?flashplayer':.*?"(.*?)".*?'file':.*?'(.*?)'.*?'streamer':.*?'(.*?)'.*?'aboutlink':.*?'(.*?)'.*?/
			if(!linkMatcher){
				log ("Castalba - No rtmp info - $videoTitle")
				return null
			}
			String swflink  = linkMatcher[0][1].trim()
			String pagelink = linkMatcher[0][4].trim()
			secCode  = linkMatcher[0][2].trim()
			rtmpUrl = "rtmp://cn001.castalba.tv/live" + " swfUrl=" + swflink + " pageURL=" + pagelink + " playpath=" + secCode 
		}
		else if (srcUrl.contains("http://liveview365.tv")){
			def secMatcher = linkTitle =~ '(?s).*?id=\'(.*?)\''
			secCode = secMatcher[0][1].trim()
			srcUrl = "http://liveview365.tv/embedded?id=" + secCode
			log("Source Link: $srcUrl")
			String linkHtml = new URL(srcUrl).getText()
			def errorMatch = linkHtml ==~ '(?s).*?alt="Content Removed.*?'
			if (errorMatch){
				log ("Liveview 365 - Content Removed - $videoTitle")
				return null
			}
			def linkMatcher = linkHtml =~ /(?s).*?SWFObject.*?'(.*?)'.*?'file',.*?'(.*?)'.*?'streamer',.*?'(.*?)liveview365'.*?'logo.link',.*?'(.*?)'.*?/
			if(!linkMatcher){
				log ("Liveview 365 - No rtmp info - $videoTitle")
				return null
			}
			String rtmplink = linkMatcher[0][3].trim()
			String swflink  = linkMatcher[0][1].trim()
			String pagelink = linkMatcher[0][4].trim()
			secCode  = linkMatcher[0][2].trim()
			rtmpUrl = rtmplink + "live/_definst_/" + secCode + " swfUrl=" + swflink + " pageURL=" + pagelink + " playpath=" + secCode 
		}
		else if (srcUrl.contains("http://www.wii-stream.com")){
			def secMatcher = linkTitle =~ '(?s).*?fid="(.*?)"'
			secCode = secMatcher[0][1].trim()
			srcUrl = "http://wii-stream.com/?p=channeldetails&id=" + secCode
			log("Source Link: $srcUrl")
			rtmpUrl = "rtmp://75.126.69.205/live swfUrl=http://wii-stream.com/player/player.swf pageURL=http://wii-stream.com/?p=channeldetails&id=" + secCode + " playpath=" + secCode 
		}
		else if (srcUrl.contains("http://www.castup.tv")){
			def secMatcher = linkTitle =~ '(?s).*?fid="(.*?)"'
			secCode = secMatcher[0][1].trim()
			srcUrl = "http://castup.tv/embed.php?u=" + secCode
			log("Source Link: $srcUrl")
			rtmpUrl = "rtmp://159.253.145.155:1935/live pageUrl=http://www.castup.tv playpath=" + secCode 
		}
		else if (srcUrl.contains("http://www.castamp.com/")){
			def secMatcher = linkTitle =~ '(?s).*?channel="(.*?)"'
			secCode = secMatcher[0][1].trim()
			srcUrl = "http://castamp.com/channel/" + secCode
			log("Source Link: $srcUrl")
			String linkHtml = new URL(srcUrl).getText()
			def errorMatch = linkHtml ==~ '(?s).*?player".*?>Channel Blocked.*?'
			if (errorMatch){
				log ("CASTAMP - Channel Blocked - $videoTitle")
				return null
			}
			def linkMatcher = linkHtml =~ /(?s).*?SWFObject.*?'(.*?)'.*?'file',.*?'(.*?)'.*?'streamer',.*?'(.*?)'.*?'logo.link',.*?'(.*?)'/
			String rtmplink = linkMatcher[0][3].trim()
			String swflink  = linkMatcher[0][1].trim()
			String pagelink = linkMatcher[0][4].trim()
			rtmpUrl = "rtmp://50.115.119.42/live/" + secCode + " swfUrl=" + swflink + " pageURL=" + pagelink + " playpath=" + secCode 
		}
/*-----------------------------------------------------------------------------
/* 
		else if (srcUrl.contains("http://www.wii-cast.tv")){
			def secMatcher = linkTitle =~ '(?s).*?fid="(.*?)"'
			secCode = secMatcher[0][1].trim()
			rtmpUrl = "rtmp://75.126.69.205/live swfUrl=http://wii-stream.com/player/player.swf pageURL=http://wii-stream.com/?p=channeldetails&id=" + secCode + " playpath=" + secCode 
		}
*/ 
		else if (srcUrl.contains("http://refreshitem")){
			secCode = "abcdefghi"
			def codeMatcher = resourceUrl =~ '^(?:https?://)?(?:www\\.)?hahasport\\.com/c-(.*?).html.*?'
			String sportCode = codeMatcher[0][1].trim()  
			rtmpUrl = "rtsp://a1709.l1856953708.c18569.g.lm.akamaistream.net:554/D/1709/18569/v" + sportCode + "/reflector:53708"
			println "$rtmpUrl"
		}
		else if (srcUrl.contains("http://lastitem")){
			secCode = "abcdefghi"
			rtmpUrl = "rtsp://a1709.l1856953708.c18569.g.lm.akamaistream.net:554/D/1709/18569/v0100/reflector:53708"
		}
		long curTimea = item.getAdditionalInfo()['curTimea'].toLong() 
		long nextRefreshi = item.getAdditionalInfo()['nextrefreshi'].toLong() 
		long defRefreshi = item.getAdditionalInfo()['defrefreshi'].toLong() 
		def cacheKey = resourceUrl + "_" +  videoUrl
		long nextRefresha = curTimea + nextRefreshi
		def expiryDate = new Date(nextRefresha *60000)
		log ("$rtmpUrl expires on $expiryDate")
		return new ContentURLContainer(fileType: MediaFileType.VIDEO, contentUrl: rtmpUrl, thumbnailUrl: thumbnailUrl, live: true, expiresOn: expiryDate, cacheKey: cacheKey, expiresImmediately: true)
	}
	static void main(args) {
		HaHaSport extractor = new HaHaSport()
		assert extractor.extractorMatches( new URL("http://www.hahasport.com/c-4.html") )
		assert !extractor.extractorMatches( new URL("http://google.com/feeds/api/standardfeeds/top_rated?time=today") )
		WebResourceContainer container  = extractor.extractItems( new URL("http://www.hahasport.com/c-7.html?&estreams=4"), -1)    
		println container
		ContentURLContainer result = extractor.extractUrl(container.getItems()[1], PreferredQuality.MEDIUM)
		print result
	}
}
